﻿using System;

using Android.App;
using Android.Content;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.OS;

namespace iXTankenAndroid
{
    [Activity(Label = "iXTanken", MainLauncher = true, Icon = "@drawable/icon", Theme = "@android:style/Theme.Light")]
    public class MainActivity : ListActivity
    {
        private MainViewModel viewModel;

        private const int MENU_ADD = 1;

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);

            viewModel = new MainViewModel();

            // Set our view from the "main" layout resource
            //SetContentView(Resource.Layout.Main);
            //Hier wird kein Layout zugewiesen, da das Setzen des ListAdapters automatisch
            //Eine ListView erzeugt, die den ganzen Bildschirm ausfüllt


            //ListAdapter = new TankVorgangListAdapter(this, Resource.Layout.Main_List_Item,viewModel.DataSource);
            ListView.TextFilterEnabled = true;  

            ListView.ItemClick += delegate (object sender, ItemEventArgs args) {  
            // When clicked, show a toast with the TextView text  
            Toast.MakeText (Application, ((TextView)args.View).Text, ToastLength.Short).Show ();  
               };  

        }

        protected override void OnResume()
        {
            base.OnResume();
            ActivityHelper.CurrentActiviy = this;
            viewModel.LoadDataAction(null);
            ListAdapter = new TankVorgangListAdapter(this, Resource.Layout.Main_List_Item, viewModel.DataSource);
        }

        public override bool OnCreateOptionsMenu(IMenu menu)
        {
            base.OnCreateOptionsMenu(menu);

            IMenuItem saveItem = menu.Add(0, MENU_ADD, 0, Resource.String.MenuAdd);
            saveItem.SetShortcut('1', 'a');
            saveItem.SetIcon(Android.Resource.Drawable.IcMenuAdd);

            return true;
        }

        public override bool OnOptionsItemSelected(IMenuItem item)
        {
            base.OnOptionsItemSelected(item);

            switch (item.ItemId)
            {
                case MENU_ADD:
                    viewModel.AddNewTankVorgang(null);
                    break;
            }
            return true;
        }
    }
}

